import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;

public class JackSparrow {

    static class Jarbol {
        long x, h;
        int originalIndex;
        double minDistance;

        public Jarbol(long x, long h, int index) {
            this.x = x;
            this.h = h;
            this.originalIndex = index;
            this.minDistance = -1.0;
        }
    }

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter pw = new PrintWriter(System.out);

        int n = Integer.parseInt(br.readLine());

        StringTokenizer stX = new StringTokenizer(br.readLine());
        StringTokenizer stH = new StringTokenizer(br.readLine());

        Jarbol[] jarboli = new Jarbol[n];
        long[] originalX = new long[n];
        long[] originalH = new long[n];

        for (int i = 0; i < n; i++) {
            originalX[i] = Long.parseLong(stX.nextToken());
            originalH[i] = Long.parseLong(stH.nextToken());
            jarboli[i] = new Jarbol(originalX[i], originalH[i], i);
        }

        Arrays.sort(jarboli, (a, b) -> Long.compare(a.x, b.x));

        long max_X_plus_H = Long.MIN_VALUE;

        for (int j = 0; j < n; j++) {
            Jarbol Pj = jarboli[j];
            long Mj = Pj.x + Pj.h; 

            if (max_X_plus_H != Long.MIN_VALUE) {
                if (max_X_plus_H >= Mj) {
                    double distance = (max_X_plus_H - Mj) / 2.0;
                    
                    if (Pj.minDistance == -1.0) {
                        Pj.minDistance = distance;
                    } else {
                        Pj.minDistance = Math.min(Pj.minDistance, distance);
                    }
                }
            }

            max_X_plus_H = Math.max(max_X_plus_H, Mj);
        }

        long max_H_minus_X = Long.MIN_VALUE;

        for (int j = n - 1; j >= 0; j--) {
            Jarbol Pj = jarboli[j];
            long Mj_prime = Pj.h - Pj.x;

            if (max_H_minus_X != Long.MIN_VALUE) {
                if (max_H_minus_X >= Mj_prime) {
                    double distance = (max_H_minus_X - Mj_prime) / 2.0;

                    if (Pj.minDistance == -1.0) {
                        Pj.minDistance = distance;
                    } else {
                        Pj.minDistance = Math.min(Pj.minDistance, distance);
                    }
                }
            }

            max_H_minus_X = Math.max(max_H_minus_X, Mj_prime);
        }

        
        String[] results = new String[n];
        for (Jarbol j : jarboli) {
            if (j.minDistance == -1.0) {
                results[j.originalIndex] = "-1";
            } else {
                long finalResult = Math.round(j.minDistance);
                results[j.originalIndex] = String.valueOf(finalResult);
            }
        }

        for (String result : results) {
            pw.println(result);
        }

        pw.flush();
        pw.close();
        br.close();
    }
}